#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Spiral TerrainMod01.fsh  by  Peace   
//https://www.shadertoy.com/view/mtyyRD
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int MAX_STEPS = 128;
#define SURFACE_DIST 0.1
const float PI = 3.14159265359;

struct Hit
{
    float dist;
    float min_dist;
    vec3 point;
    vec3 normal;
};

float spiral(vec3 p) {
    vec2 uv = p.xy;
    float l = length(uv) * 8.0 - iTime;
    vec2 p2 = vec2(sin(l), cos(l));
    float d = 2.0 - pow(distance(uv, p2), 0.1);
    d = pow(d, 2.0 - length(uv) * 0.5 + 1.0 / (0.2 + dot(uv, uv)));
    return dot(p, normalize(vec3(0.2, 0.2, -1))) + d;
}

float SDF(vec3 point)
{
    return spiral(point);
}

vec3 getNormal(vec3 point, float dist)
{
    vec2 e = vec2(0.002, 0.0);
    return normalize(dist - vec3(SDF(point - e.xyy), SDF(point - e.yxy), SDF(point - e.yyx)));
}

Hit raymarch(vec3 ro, vec3 rd)
{
    Hit hit;
    hit.min_dist = 99999.;
    hit.point = ro;
    for (int i = 0; i < MAX_STEPS; ++i)
    {
        float sdf = SDF(hit.point);
        if (abs(sdf) < hit.min_dist) 
        {
            hit.min_dist = sdf;
            hit.normal = getNormal(hit.point, hit.min_dist);
            if (sdf <= SURFACE_DIST)
                break;
        }
        hit.point += rd * sdf * 0.1;
        hit.dist += sdf;
    }
    
    return hit;
}

vec3 gammaCorrect(vec3 color, float gamma)
{
    return pow(color, vec3(1.0 / gamma));
}

float diffuse(vec3 normal, vec3 light_dir)
{
    return max(0.0, dot(normal, light_dir));
}
    
float specular(vec3 light_dir, vec3 ray_dir, vec3 normal)
{
    vec3 halfway = normalize(light_dir + ray_dir);
    return max(0.0, dot(normal, halfway));
}

vec3 gradient(float z, float d) {
    return mix(
		vec3(0.4, 0.8, 1.0),
		mix(
			vec3(0.0, 0.0, 1.0),
			vec3(1),
			z * 0.55
		),
		1.0 / (d * 0.033)
	);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float mr = min(iResolution.x, iResolution.y);
    vec2 uv = (fragCoord * 2. - iResolution.xy) / mr;
    vec3 ro = vec3(0, 0, -1);
    vec3 rd = normalize(vec3(uv, 1));
    
    Hit hit = raymarch(ro, rd);
    
    vec3 lp = vec3(6, 8, -4);
    vec3 ld = normalize(lp - hit.point);
    
    vec3 vd = normalize(ro - hit.point);
    float s = specular(ld, vd, hit.normal);
    float spec = pow(s, 32.);
    spec += pow(s, 64.);
    spec += pow(specular(normalize(vec3(5, -10, -2)), vd, hit.normal), 8.);
    float diff = diffuse(hit.normal, ld);
    float light = spec + diff;

    vec3 color = gradient(hit.point.z, hit.dist + 32. * light);
    fragColor = vec4(color, 1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

